/*************************************************************************************************
 *
 *   Copyright (c) Hilscher GmbH. All Rights Reserved.
 *
 *************************************************************************************************
 * @file CifX_ApDemo.cpp
 *
 * @brief This is the base file for all Hilscher CifX RTE example applications.
 * 
 * @author R. Walter (basis: E. Ott)
 *
 */

/* application header */
#include "Application.h"


/*************************************************************************************************
 * @brief This method is the main entry point for the application task running under Win32.
 * 
 * @param argc Number of arguments.
 * @param argv Poniter to arguments.
 *
 * @return int Returns 0 if no error, otherwise it will return an error code.
 *
 */
int main(int argc, void* argv[])
{
  /* return value of main function */
  TLR_RESULT tResult = TLR_S_OK;

  /* pointer to common application data */  
  APPLICATION_T* ptApp = NULL;

  /* create resources */
  tResult = App_CreateResources(&ptApp);
  if (TLR_S_OK != tResult)
  {
    return 1;  
  }

  /* enter the startup sequence of the application */
  tResult = App_Main(ptApp);

  /* release all resources */
  tResult = App_FreeResources(ptApp);
  if (TLR_S_OK != tResult)
  {
    return 1;  
  }

  /* exit */
  return 0;
}
